<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns="http://www.w3.org/1999/xhtml"
 xpath-default-namespace="http://www.datypic.com/books/ns">

 <xsl:output method="xhtml"/>
 <xsl:import-schema namespace="http://www.datypic.com/books/ns" schema-location="books.xsd"/>
 <xsl:import-schema namespace="http://www.w3.org/1999/xhtml"
  schema-location="xhtml1-strict.xsd"/>
 
 <xsl:template match="books">
  <html xsl:validation="strict">
   <head><title>Books</title></head>
   <body>
    <table border="1">
     <xsl:apply-templates/>
    </table>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="schema-element(book)">
  <tr>
   <td>
    <xsl:value-of select="title"/>
   </td>
   <td>
    <xsl:value-of select="author/person/last"/>
   </td>
   <td>
    <xsl:value-of select="author/person/first"/>
   </td>
   <td>
    <xsl:value-of select="price"/>
   </td>
  </tr>
 </xsl:template>

</xsl:stylesheet>
