<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:dtyf="http://www.datypic.com/functions"
    xpath-default-namespace="http://www.datypic.com/books/ns">
    
    <xsl:output method="html"/>
    
    <xsl:template match="books">
        <html>
            <body>
                <table border="1">
                    <xsl:apply-templates/>
                </table>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="book">
        <tr>
            <td>
                <xsl:value-of select="title"/>
            </td>
            <td>
                <xsl:value-of select="author"/>
            </td>
            <td>
                <xsl:value-of select="dtyf:calculate-price(price, discount)"/>
            </td>
        </tr>
    </xsl:template>
    
    
    <xsl:function name="dtyf:calculate-price" as="xs:decimal">
        <xsl:param name="price" as="xs:decimal"/>
        <xsl:param name="discount" as="xs:decimal?"/>
        <xsl:choose>
            <xsl:when test="$discount > 0 and $discount &lt; $price">
                <xsl:sequence select="$price - $discount"/>    
            </xsl:when>
            <xsl:otherwise>
                <xsl:sequence select="$price"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:function>
    
</xsl:stylesheet>
