<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:dtyf="http://www.datypic.com/functions"
 xpath-default-namespace="http://www.datypic.com/books/ns">

 <xsl:output method="html"/>

 <xsl:template match="books">
  <html>
   <body>
    <table border="1">
     <xsl:apply-templates/>
    </table>
   </body>
  </html>
 </xsl:template>

 <xsl:template match="book">
  <tr>
   <td><xsl:value-of select="title"/></td>
   <td><xsl:value-of select="dtyf:format-person-name(author/person)"/></td>
   <td><xsl:value-of select="price"/></td>
  </tr>
 </xsl:template>

 <xsl:function name="dtyf:format-person-name">
  <xsl:param name="person"/>
  <xsl:value-of select="$person/last"/>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="$person/first"/>
 </xsl:function>
</xsl:stylesheet>
