<?xml version="1.0"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:w="http://schemas.openxmlformats.org/wordprocessingml/2006/main"
        exclude-result-prefixes="w">
<xsl:output method="xml" indent="yes"/>
<xsl:template match="/">
  <document>
    <xsl:apply-templates select=".//w:p"/>
  </document>
</xsl:template>

<xsl:template match="w:p">
  <xsl:variable name="size" select="w:pPr/w:rPr/w:sz/@w:val"/>
  <xsl:choose>
    <xsl:when test="($size > 32) and exists(w:pPr/w:rPr/w:b)">
      <h1>
        <xsl:apply-templates select="*"/>
      </h1>
    </xsl:when>
    <xsl:when test="($size > 25) and exists(w:pPr/w:rPr/w:i)">
      <h2>
        <xsl:apply-templates select="*"/>
      </h2>
    </xsl:when>
    <xsl:otherwise>
      <p>
        <xsl:apply-templates select="*" mode="char-formatting"/>
      </p>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="w:r" mode="char-formatting">
  <xsl:choose>
    <xsl:when test="w:rPr/w:b">
      <b>
        <xsl:apply-templates select="*"/>
      </b>
    </xsl:when>
    <xsl:when test="w:rPr/w:i">
      <i>
        <xsl:apply-templates select="*"/>
      </i>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="*"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

</xsl:stylesheet>
