<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="yes"/>
<xsl:variable name="chapRegex" select="'^\s*Chapter\s+(\d+)\s*:\s*(.*)$'"/>
<xsl:variable name="secRegex" select="'^\s*(\d+\.\d+)\s*(.*)$'"/>

<xsl:template match="document">
  <xsl:variable name="renamed" as="element()*">
    <xsl:apply-templates select="*" mode="rename"/>
  </xsl:variable>
  <document>
    <xsl:for-each-group select="$renamed" group-starting-with="chapTitle">
      <chapter num="{replace(current-group()[self::chapTitle],$chapRegex,'$1')}">
        <xsl:for-each-group select="current-group()" group-starting-with="secTitle">
          <xsl:choose>
            <xsl:when test="current-group()[self::secTitle]">
              <section num="{replace(current-group()[self::secTitle],$secRegex,'$1')}">
                <xsl:apply-templates select="current-group()"/>
              </section>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="current-group()"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each-group>
      </chapter>
    </xsl:for-each-group>
  </document>
</xsl:template>

<xsl:template match="p[matches(.,$chapRegex)]" mode="rename">
  <chapTitle>
	 <xsl:copy-of select="node()"/>
  </chapTitle>
</xsl:template>

<xsl:template match="p[matches(.,$secRegex)]" mode="rename">
  <secTitle>
	 <xsl:copy-of select="node()"/>
  </secTitle>
</xsl:template>

<xsl:template match="text()" priority="1">
  <xsl:choose>
    <xsl:when test="matches(.,$chapRegex) and (. is parent::chapTitle/node()[1])">
      <xsl:value-of select="replace(.,$chapRegex,'$2')"/>
    </xsl:when>
    <xsl:when test="matches(.,$secRegex) and (. is parent::secTitle/node()[1])">
      <xsl:value-of select="replace(.,$secRegex,'$2')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:copy-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="node()" mode="#all">
  <xsl:copy>
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates mode="#current"/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
