<xsl:stylesheet version="2.0" 
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output indent="yes"/>

<xsl:template match="html">
  <document>
    <xsl:for-each-group select="*" group-starting-with="h1">
      <section level="1">
        <xsl:for-each-group select="current-group()" 
                            group-starting-with="h2">
          <xsl:choose>
            <xsl:when test="current-group()[self::h2]">
              <section level="2">
                <xsl:apply-templates select="current-group()"/>
              </section>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="current-group()"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:for-each-group>
      </section>
    </xsl:for-each-group>
  </document>
</xsl:template>

<xsl:template match="h1|h2">
  <heading>
    <xsl:apply-templates/>
  </heading>
</xsl:template>


<xsl:template match="node()">
  <xsl:copy>
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>
