<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
 xmlns:tr="http://datypic.com/theftreport/exchange/1.0"
 xmlns:nc="http://niem.gov/niem/niem-core/2.0"
 xmlns:trext="http://datypic.com/theftreport/extension/1.0"
 xmlns:j="http://niem.gov/niem/domains/jxdm/4.1"
 xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
 xmlns:s="http://niem.gov/niem/structures/2.0">

<xsl:output method="html" encoding="US-ASCII" indent="yes"/>

<xsl:template match="tr:TheftReport">
	<html>
		<style type="text/css">
			body {font-family:Arial}
			th {padding:5px;vertical-align:top;font-size:12pt;text-align:right;font-weight:bold}
			td {padding:3px;vertical-align:top;font-size:10pt}
		</style>
		<body>
			<h1>
				<xsl:text>Theft Report for </xsl:text>
				<xsl:call-template name="format-date">
					<xsl:with-param name="date" select="tr:TheftReportDate"/>
				</xsl:call-template>
			</h1>
			<xsl:apply-templates select="trext:Theft"/>
		</body>
	</html>
</xsl:template>

<xsl:template match="trext:Theft">
	<xsl:variable name="theftid" select="@s:id"/>
	<h2>Theft <xsl:value-of select="position()"/></h2>
	<table>
			<tr>
				<th>Date/Time:</th>
				<td>
					<xsl:call-template name="format-datetime">
						<xsl:with-param name="date" select="nc:ActivityDate/nc:DateTime"/>
					</xsl:call-template>
				</td>
			</tr>
			<xsl:apply-templates select="//nc:Location[@s:id=//j:ActivityLocationAssociation[nc:ActivityReference/@s:ref=$theftid]/nc:LocationReference/@s:ref]"/>
			<xsl:apply-templates select="//trext:Vehicle[@s:id=//nc:ActivityConveyanceAssociation[nc:ActivityReference/@s:ref=$theftid]/nc:ConveyanceReference/@s:ref]"/>
			<xsl:apply-templates select="//trext:Bicycle[@s:id=//nc:ActivityConveyanceAssociation[nc:ActivityReference/@s:ref=$theftid]/nc:ConveyanceReference/@s:ref]"/>
			<xsl:apply-templates select="//j:Victim[@s:id=//j:ActivityVictimAssociation[nc:ActivityReference/@s:ref=$theftid]/j:VictimReference/@s:ref]"/>
			<xsl:apply-templates select="//j:Witness[@s:id=//j:ActivityWitnessAssociation[nc:ActivityReference/@s:ref=$theftid]/j:WitnessReference/@s:ref]"/>
		</table>
		<hr/>
</xsl:template>

<xsl:template match="nc:Location">
	<tr>
		<th>Location:</th>
		<td>
			<xsl:apply-templates select="nc:LocationAddress/nc:StructuredAddress"/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="trext:Vehicle">
	<tr>
		<th>Property:</th>
		<td><b>Type</b>: Motor Vehicle<br/>
			<b>Serial number</b>: <xsl:value-of select="nc:ItemSerialIdentification/nc:IdentificationID"/><br/>
			<b>Description</b>: <xsl:value-of select="nc:ItemDescriptionText"/><br/>
			<b>Color</b>: <xsl:value-of select="nc:VehicleColorPrimaryCode"/><br/>
			<b>License Plate</b>: <xsl:value-of select="nc:ConveyanceRegistrationPlateIdentification/nc:IdentificationID"/><br/>
			<b>Tax Class Code</b>: 
				<xsl:call-template name="format-vehiclecategory">
					<xsl:with-param name="value" select="trext:VehicleTaxClassCode"/>
				</xsl:call-template>
		</td>
	</tr>
</xsl:template>

<xsl:template match="trext:Bicycle">
	<tr>
		<th>Property:</th>
		<td><b>Type</b>: Bicycle<br/>
			<b>Serial number</b>: <xsl:value-of select="nc:ItemSerialIdentification/nc:IdentificationID"/><br/>
			<b>Description</b>: <xsl:value-of select="nc:ItemDescriptionText"/><br/>
			<b>Color</b>: <xsl:value-of select="nc:VehicleColorPrimaryCode"/><br/>
			<b>Registered</b>: <xsl:value-of select="trext:BicycleRegisteredIndicator"/><br/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="j:Victim">
	<xsl:variable name="person" select="//j:Person[@s:id=current()/nc:RoleOfPersonReference/@s:ref]"/>
	<tr>
		<th>Victim:</th>
		<td><b>Name</b>: <xsl:apply-templates select="$person/nc:PersonName"/><br/>
			<b>Drivers license number</b>: <xsl:value-of select="$person/j:PersonAugmentation/nc:DriverLicense/nc:DriverLicenseIdentification/nc:IdentificationID"/>
		</td>
	</tr>
</xsl:template>

<xsl:template match="j:Witness">
	<xsl:variable name="person" select="//j:Person[@s:id=current()/nc:RoleOfPersonReference/@s:ref]"/>
	<tr>
		<th>Witness:</th>
		<td><b>Name</b>: <xsl:apply-templates select="$person/nc:PersonName"/><br/>
			<b>Drivers license number</b>: <xsl:value-of select="$person/j:PersonAugmentation/nc:DriverLicense/nc:DriverLicenseIdentification/nc:IdentificationID"/><br/>
			<b>Account</b>: <xsl:value-of select="j:WitnessAccountDescriptionText"/>
		</td>
	</tr>
</xsl:template>


<xsl:template match="nc:PersonName">
	<xsl:value-of select="concat(
					nc:PersonSurName, ', ',
					nc:PersonGivenName)"/>
</xsl:template>

<xsl:template match="nc:StructuredAddress">
	<xsl:for-each select="nc:LocationStreet/nc:StreetFullText">
		<xsl:value-of select="."/>
		<br/>
	</xsl:for-each>
	<xsl:value-of select="nc:LocationCityName"/>
	<xsl:if test="nc:LocationStateUSPostalServiceCode">
		<xsl:text>, </xsl:text>
		<xsl:value-of select="nc:LocationStateUSPostalServiceCode"/>
	</xsl:if>
	<xsl:text> </xsl:text>
	<xsl:value-of select="nc:LocationPostalCode"/>
	<br/>
	<xsl:text>County: </xsl:text>
	<xsl:call-template name="format-county">
		<xsl:with-param name="value" select="trext:LocationCountyCode"/>
	</xsl:call-template>	
</xsl:template>

<xsl:template name="format-date">
	<xsl:param name="date"/>
	<xsl:value-of select="concat(
					substring($date,6,2), '/',
					substring($date,9,2), '/',
					substring($date,1,4))"/>
</xsl:template>

<xsl:template name="format-datetime">
	<xsl:param name="date"/>
	<xsl:value-of select="concat(
					substring($date,6,2), '/',
					substring($date,9,2), '/',
					substring($date,1,4),' ',
					substring($date,12,2),':',
					substring($date,15,2),':',
					substring($date,18,2))"/>
</xsl:template>

<xsl:template name="format-county">
   <xsl:param name="value"/>
   <xsl:choose>
      <xsl:when test="$value='A'">A: Ascot County</xsl:when>
      <xsl:when test="$value='B'">B: Burke County</xsl:when>
      <xsl:when test="$value='C'">C: Cross County</xsl:when>
      <xsl:otherwise>
         <xsl:value-of select="$value"/>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="format-vehiclecategory">
   <xsl:param name="value"/>
   <xsl:choose>
      <xsl:when test="$value='1'">1	Commercial</xsl:when>
      <xsl:when test="$value='2'">2	Commercial-Large</xsl:when>
      <xsl:when test="$value='3'">3	Government</xsl:when>
      <xsl:when test="$value='4'">4	Private</xsl:when>
      <xsl:otherwise>
         <xsl:value-of select="$value"/>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="text()"/>

</xsl:stylesheet>