(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 28-5 Passing parameters via RESTXQ:)
xquery version "3.0";
module namespace prod = "http://datypic.com/prod";
declare namespace rest = "http://exquery.org/ns/restxq";
declare
  %rest:GET
  %rest:path("/products")
  %rest:query-param("dept", "{$dept}", "*")
  function prod:prods-by-dept($dept) {
    <html>
      <body>{
        for $prod in doc("catalog.xml")//product[@dept=$dept or $dept = '*']
        let $num := data($prod/number)
        return <p><a href="product/{$num}">{$num}</a></p>
   }</body>
</html>
};