(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 23-4 Price list generation with function for discount algorithm:)
xquery version "3.0";
declare function local:price-list
   ($price-doc as document-node(),
    $price-calc-func as function(element(prod)) as xs:decimal) {
    <html>
      <head>
        <title>Price List</title>
        <link href="companystandard.css"/>
      </head>
      <body>
        <h1>Price List</h1>
        <table>
          <tr>
            <th>Prod number</th>
            <th>Price</th>
          </tr>
          {for $prod in $price-doc//priceList[@effDate < current-date()]/prod
          return
          <tr>
            <td>{data($prod/@num)}</td>
            <td>{$price-calc-func($prod)}</td>
          </tr>
        }</table>
      </body>
    </html>
};
declare function local:price-based-on-discount
  ($prod as element(prod)) as xs:decimal {
   if (exists($prod/discount))
   then xs:decimal($prod/price) - xs:decimal($prod/discount)
   else xs:decimal($prod/price)
};
declare function local:price-based-on-percent
 ($prod as element(prod)) as xs:decimal {
   xs:decimal($prod/price) * .90
};