(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 16-3 Using the catch variables:)
xquery version "3.0";
declare namespace err = "http://www.w3.org/2005/xqt-errors";
let $order-date := doc("order.xml")/order/@date
return 
try {
  if (not($order-date)) 
  then error(QName("http://datypic.com/err", "MissingOrdDate"),
             "Order date must be present")
  else if (not($order-date castable as xs:date)) 
  then error(QName("http://datypic.com/err", "InvalidOrdDate"),
             "Order date must be YYYY-MM-DD")
  else concat("The order-date is ",
         format-date(xs:date($order-date), "[M01]/[D01]/[Y0001]"))
}
catch * { 
  concat("[", $err:line-number, ": ", $err:column-number,
         "] Error ", $err:code, ": ", $err:description)
}