(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 9-23 Useful function: functx:change-element-names-deep:)
declare namespace functx = "http://www.functx.com";
declare function functx:change-element-names-deep
  ($nodes as node()*, $oldNames as xs:QName*,
   $newNames as xs:QName*) as node()* {

  if (count($oldNames) != count($newNames))
  then error(xs:QName("Different_Number_Of_Names"))
  else for $node in $nodes
       return if ($node instance of element())
              then let $newName :=
                     if (node-name($node) = $oldNames)
                     then $newNames[index-of($oldNames, node-name($node))]
                     else node-name($node)
                   return element {$newName}
                     {$node/@*,
                      functx:change-element-names-deep($node/node(),
                                              $oldNames, $newNames)}
              else $node
};