(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 9-18 Useful function: functx:add-attributes:)
declare namespace functx = "http://www.functx.com";
declare function functx:add-attributes
  ( $elements as element()*,
    $attrNames as xs:QName*,
    $attrValues as xs:anyAtomicType* )  as element()* {
       
   for $element in $elements
   return element { node-name($element)}
                  { for $attrName at $seq in $attrNames
                    return if ($element/@*[node-name(.) = $attrName])
                           then ()
                           else attribute {$attrName}
                                          {$attrValues[$seq]},
                    $element/@*,
                    $element/node() }
};