(: XQuery by Priscilla Walmsley (c) 2016 Priscilla Walmsley:)
(:Example 8-2 Handling the empty sequence:)
declare function local:discountPrice(
  $price as xs:decimal?,
  $discount as xs:decimal?,
  $maxDiscountPct as xs:integer?) as xs:double?
{
   let $newDiscount    := if ($discount) then $discount else 0
   let $maxDiscount    := if ($maxDiscountPct)
                          then ($price * $maxDiscountPct) div 100
                          else 0
   let $actualDiscount := min( ($maxDiscount, $newDiscount) )
   return ($price - $actualDiscount)
};
let $prod := doc("prices.xml")//prod[1]
return local:discountPrice($prod/price, $prod/discount, 15)